<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$pdo = getDBConnection();

// Handle URL updates
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'update_url':
                $url = $_POST['url'] ?? '';
                $title = $_POST['title'] ?? '';
                $description = $_POST['description'] ?? '';
                
                if (!empty($url)) {
                    // Update the active URL
                    $stmt = $pdo->prepare("UPDATE webview_urls SET is_active = FALSE");
                    $stmt->execute();
                    
                    $stmt = $pdo->prepare("INSERT INTO webview_urls (url, title, description, is_active) VALUES (?, ?, ?, TRUE)");
                    $stmt->execute([$url, $title, $description]);
                    
                    $success = "URL updated successfully!";
                }
                break;
        }
    }
}

// Get current active URL
$stmt = $pdo->prepare("SELECT * FROM webview_urls WHERE is_active = TRUE ORDER BY updated_at DESC LIMIT 1");
$stmt->execute();
$currentUrl = $stmt->fetch();

// Get URL history
$stmt = $pdo->prepare("SELECT * FROM webview_urls ORDER BY updated_at DESC LIMIT 10");
$stmt->execute();
$urlHistory = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar-brand {
            font-weight: 600;
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            border: none;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .url-preview {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1rem;
            border-left: 4px solid #667eea;
        }
        .history-item {
            transition: all 0.3s ease;
        }
        .history-item:hover {
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-globe me-2"></i>
                <?php echo APP_NAME; ?>
            </a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['admin_username']); ?>
                </span>
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <?php if (isset($success)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?php echo htmlspecialchars($success); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-edit me-2"></i>
                            Update WebView URL
                        </h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="update_url">
                            
                            <div class="mb-3">
                                <label for="url" class="form-label">WebView URL *</label>
                                <input type="url" class="form-control" id="url" name="url" 
                                       value="<?php echo htmlspecialchars($currentUrl['url'] ?? ''); ?>" 
                                       placeholder="https://example.com" required>
                                <div class="form-text">Enter the URL that will be displayed in the WebView app</div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="title" class="form-label">Title</label>
                                <input type="text" class="form-control" id="title" name="title" 
                                       value="<?php echo htmlspecialchars($currentUrl['title'] ?? ''); ?>" 
                                       placeholder="Website Title">
                            </div>
                            
                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="3" 
                                          placeholder="Brief description of the website"><?php echo htmlspecialchars($currentUrl['description'] ?? ''); ?></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>
                                Update URL
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-eye me-2"></i>
                            Current URL Preview
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if ($currentUrl): ?>
                            <div class="url-preview">
                                <h6><?php echo htmlspecialchars($currentUrl['title'] ?: 'No Title'); ?></h6>
                                <p class="text-muted mb-2"><?php echo htmlspecialchars($currentUrl['description'] ?: 'No description'); ?></p>
                                <a href="<?php echo htmlspecialchars($currentUrl['url']); ?>" target="_blank" class="text-primary">
                                    <?php echo htmlspecialchars($currentUrl['url']); ?>
                                </a>
                                <div class="mt-2">
                                    <small class="text-muted">
                                        Last updated: <?php echo date('M j, Y g:i A', strtotime($currentUrl['updated_at'])); ?>
                                    </small>
                                </div>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No active URL set</p>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-history me-2"></i>
                            URL History
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <?php foreach ($urlHistory as $url): ?>
                                <div class="list-group-item history-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1"><?php echo htmlspecialchars($url['title'] ?: 'No Title'); ?></h6>
                                            <p class="mb-1 text-muted small"><?php echo htmlspecialchars($url['url']); ?></p>
                                            <small class="text-muted">
                                                <?php echo date('M j, Y g:i A', strtotime($url['updated_at'])); ?>
                                            </small>
                                        </div>
                                        <?php if ($url['is_active']): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 