<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if (!in_array($_SERVER['REQUEST_METHOD'], ['POST', 'DELETE'])) {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

try {
    // Include database configuration
    require_once __DIR__ . '/../config.php';
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate input
    if (empty($input['id'])) {
        throw new Exception('ID is required');
    }
    
    $id = (int)$input['id'];
    
    // Get database connection
    $pdo = getDBConnection();
    
    // Check if item exists
    $stmt = $pdo->prepare("SELECT id FROM webview_urls WHERE id = ?");
    $stmt->execute([$id]);
    
    if ($stmt->rowCount() === 0) {
        throw new Exception('WebView item not found');
    }
    
    // Delete the item
    $stmt = $pdo->prepare("DELETE FROM webview_urls WHERE id = ?");
    $stmt->execute([$id]);
    
    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'WebView item deleted successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}