<?php
// Include your admin authentication check here
// require_once 'auth_check.php';

$configFile = __DIR__ . '/ads_config.json';
$currentConfig = json_decode(file_get_contents($configFile), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newConfig = [
        'showBannerAds' => isset($_POST['showBannerAds']),
        'showInterstitialAds' => isset($_POST['showInterstitialAds']),
        'bannerAdUnitId' => $_POST['bannerAdUnitId'] ?? '',
        'interstitialAdUnitId' => $_POST['interstitialAdUnitId'] ?? '',
        'interstitialAdFrequency' => (int)($_POST['interstitialAdFrequency'] ?? 3)
    ];
    
    file_put_contents($configFile, json_encode($newConfig, JSON_PRETTY_PRINT));
    $currentConfig = $newConfig;
    $success = "Ad settings updated successfully!";
}

// Include your admin header
// include 'admin_header.php';
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Ad Settings</h3>
    </div>
    <div class="card-body">
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>
        
        <form method="post">
            <div class="form-group">
                <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" id="showBannerAds" 
                        name="showBannerAds" <?php echo $currentConfig['showBannerAds'] ? 'checked' : ''; ?>>
                    <label class="custom-control-label" for="showBannerAds">Show Banner Ads</label>
                </div>
            </div>
            
            <div class="form-group">
                <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" id="showInterstitialAds" 
                        name="showInterstitialAds" <?php echo $currentConfig['showInterstitialAds'] ? 'checked' : ''; ?>>
                    <label class="custom-control-label" for="showInterstitialAds">Show Interstitial Ads</label>
                </div>
            </div>
            
            <div class="form-group">
                <label>Banner Ad Unit ID</label>
                <input type="text" class="form-control" name="bannerAdUnitId" 
                    value="<?php echo htmlspecialchars($currentConfig['bannerAdUnitId']); ?>">
            </div>
            
            <div class="form-group">
                <label>Interstitial Ad Unit ID</label>
                <input type="text" class="form-control" name="interstitialAdUnitId" 
                    value="<?php echo htmlspecialchars($currentConfig['interstitialAdUnitId']); ?>">
            </div>
            
            <div class="form-group">
                <label>Interstitial Ad Frequency (number of interactions)</label>
                <input type="number" class="form-control" name="interstitialAdFrequency" min="1" 
                    value="<?php echo (int)$currentConfig['interstitialAdFrequency']; ?>">
            </div>
            
            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
</div>

<?php
// Include your admin footer
// include 'admin_footer.php';
?>